/*
 * Decompiled with CFR 0.152.
 */
package com.xfy.developer.xvcd2jar;

import com.xfy.common.dom.ls.SystemXfrService;
import com.xfy.common.vc.SystemXvcdService;
import com.xfy.place.XfyObject;
import com.xfy.place.XfyPlace;
import com.xfy.place.resource.ResourceUtilities;
import com.xfy.place.util.EncodedURL;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SystemScripts
extends XfyObject
implements SystemXvcdService,
SystemXfrService {
    public static final String SCRIPTS = "scripts";
    public static final String FILE_NAME = "fileName";
    public static final String SYSTEM_SCRIPT_XML = "system-script.xml";
    public static String SYSTEM_SCRIPT_NS = "http://plugin.xfy.com/DevelopersToolkit/xvcd2jar/system-script";
    public static final String ENTRY = "entry";
    public static final String TYPE = "type";

    public EncodedURL[] getXvcdResources() {
        Object object;
        Element element = this.getRoot();
        if (element == null) {
            return null;
        }
        EncodedURL encodedURL = ResourceUtilities.getResourceURL(((Object)((Object)this)).getClass());
        ArrayList<EncodedURL> arrayList = new ArrayList<EncodedURL>();
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            Element element2;
            if (object.getNodeType() != 1 || !SYSTEM_SCRIPT_NS.equals(object.getNamespaceURI()) || !ENTRY.equals(object.getLocalName()) || !"xvcd".equals((element2 = (Element)object).getAttribute(TYPE))) continue;
            String string = this.getScriptFileName(element2);
            EncodedURL encodedURL2 = this.createUrl(encodedURL, string);
            arrayList.add(encodedURL2);
        }
        object = new EncodedURL[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public EncodedURL[] getXfrResources() {
        Object object;
        Element element = this.getRoot();
        if (element == null) {
            return null;
        }
        EncodedURL encodedURL = ResourceUtilities.getResourceURL(((Object)((Object)this)).getClass());
        ArrayList<EncodedURL> arrayList = new ArrayList<EncodedURL>();
        for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
            Element element2;
            if (object.getNodeType() != 1 || !SYSTEM_SCRIPT_NS.equals(object.getNamespaceURI()) || !ENTRY.equals(object.getLocalName()) || !"xfr".equals((element2 = (Element)object).getAttribute(TYPE))) continue;
            String string = this.getScriptFileName(element2);
            EncodedURL encodedURL2 = this.createUrl(encodedURL, string);
            arrayList.add(encodedURL2);
        }
        object = new EncodedURL[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private EncodedURL createUrl(EncodedURL encodedURL, String string) {
        try {
            return EncodedURL.getInstance((EncodedURL)encodedURL, (String)string);
        }
        catch (MalformedURLException malformedURLException) {
            XfyPlace.getLogger().info("System XVCD or Xfr not found:" + encodedURL + string);
            return null;
        }
    }

    private Element getRoot() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(SystemScripts.class.getResource(SYSTEM_SCRIPT_XML).toString());
            Element element = document.getDocumentElement();
            if (!SYSTEM_SCRIPT_NS.equals(element.getNamespaceURI()) || !SCRIPTS.equals(element.getLocalName())) {
                return null;
            }
            return element;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getScriptFileName(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !SYSTEM_SCRIPT_NS.equals(node.getNamespaceURI()) || !FILE_NAME.equals(node.getLocalName())) continue;
            return node.getFirstChild().getNodeValue();
        }
        return "";
    }
}

